<?php require_once('functions.php'); if (!empty($breadcrumb)):?><div class="breadcrumb" xmlns:v="http://rdf.data-vocabulary.org/#"><?php echo $breadcrumb ?></div><?php endif;?>
<div class="profile-wrapper" itemprop="accountablePerson" itemscope="itemscope">
	<div class="profile" itemtype="http://schema.org/Person" itemscope="itemscope" itemprop="Person">
		<h1 class="title-post" itemprop="name"><?php echo $name ?></h1>
		<div class="bio" itemprop="description"><?php echo $about ?></div>
	</div>
</div>

<h2 class="post-index"><?php echo i18n_local('posts_by_this_author') ?>:</h2>
<?php if(!empty($posts)) {?>
<ul class="post-list">
	<?php $i = 0; $len = count($posts);?>
		<?php foreach($posts as $p):?>
		<?php
			if ($i == 0) {
				$class = 'post first';
				}
				elseif ($i == $len - 1) {
					$class = 'post last';
				}
				else {
					$class = 'post';
				}
				$i++;
    ?>
    <div class="<?php echo $class ?>" itemprop="blogPost" itemscope="itemscope" itemtype="http://schema.org/BlogPosting">
    	
        <div class="main author">
        
			<h2 class="title-index" itemprop="name"><a href="<?php echo $p->url?>"><?php echo $p->title ?></a></h2>
			<div class="metabar">
				<span itemprop="datePublished"><?php echo format_date($p->date) ?></span> - <?php echo i18n_local('posted_in') ?>
				<span itemprop="articleSection"><?php echo $p->tag ?></span>
			</div>
            
			<div class="teaser-body" itemprop="articleBody">				
				<?php echo get_teaser($p->body, $p->url)?>
			</div>
    </div>
   
    <?php endforeach;?>

</ul>
<?php if (!empty($pagination['prev']) || !empty($pagination['next'])):?>
	<div class="pager">
		<?php if (!empty($pagination['prev'])):?>
			<span><a href="?page=<?php echo $page-1?>" class="pagination-arrow newer" rel="prev"><?php echo ucfirst(i18n_local('newer'))?></a></span>
		<?php endif;?>
		<?php if (!empty($pagination['next'])):?>
			<span><a href="?page=<?php echo $page+1?>" class="pagination-arrow older" rel="next"><?php echo ucfirst(i18n_local('older'))?></a></span>
		<?php endif;?>
	</div>
<?php endif;?>
<?php } else { echo '<p>&nbsp;&nbsp;'.i18n_local('no_posts_found').'</p>'; }?>