<?php require_once('functions.php');?><!DOCTYPE html>
<html lang="<?php echo str_replace('_','-',config('language'));?>">
<head>
    <?php head_contents() ?>    
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">  
    <meta charset="utf-8">		
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
	    /* Social profiles*/
	    $twitterurl = config('social.twitter');
	    $facebookurl = config('social.facebook');
	    $googleurl = config('social.google');
	    $tumblrurl = config('social.tumblr');

	    include("include/seo.php");
	    include("include/fonts.php");
	?>
    
    <title><?php echo blog_title() ?></title>
    
    <link rel="stylesheet" href="<?php echo site_url().$THEMECSS ?>style.css" />
    <link href="//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css" rel="stylesheet" />
    <meta content="<?php echo blog_title(); ?>" itemprop="name" />
    <script src="<?php echo site_url().$THEMEJS;?>pageload.min.js" type="text/javascript"></script>
    
    <?php     
        include("include/background.php");
        include("include/fonts.php"); 
	?>
    
</head>

<body class="<?php echo $bodyclass; ?>" itemscope="itemscope" itemtype="http://schema.org/Blog">

    <div class="wrapper">
	    <nav id="menu" class="responsive">
	    	<?php menu() ?><h4 class="sitename"><?php echo config('blog.title')?></h4>
	    </nav>
        
	    <div class="content">
	       <?php echo content() ?>
	    </div>
        
	    <div class="footerbar">
		    <?php include("include/socialbar.php"); ?>
            
			<div class="archive">
                <h3><?php echo i18n_local('archive') ?></h3>
				<?php archive_list() ?>
			</div>
            
            <div class="search">
              <h3><?php echo i18n_local('search') ?></h3>
              <?php search(i18n_local('search')) ?>
            </div>

			<div class="tagcloud">
                <h3><?php echo i18n_local('tag') ?></h3>
				<?php tag_cloud() ?>
			</div>
	    </div>
        
        <footer>
            <p><?php echo blog_description() ?></p>
            <p class="copyright"><?php echo copyright();?> | Aliceblue Theme for <a href="//www.htmly.com">HTMLy</a><!-- Aliceblue (modified by @fabianosantosnet) is based on sideblog htmly theme --></p>
        </footer>
    </div>
</body>
</html>

