<?php
## GLOBALS VARS
$d= explode('themes',str_replace('\\','/',__FILE__));
$d=explode('/',$d[1]);
$THEMEDIR='themes/'.$d[1].'/';
$THEMEIMG=$THEMEDIR.'img/';
$THEMEJS=$THEMEDIR.'js/';
$THEMECSS=$THEMEDIR.'css/';
$THEMELANG=$THEMEDIR.'lang/';


function i18n_local($key, $value = null)
{
    static $_i18n = array();

	if( !($_i18n_local = @parse_ini_file(dirname(__FILE__).'/lang/'.config('language').'.ini', true)) )
	
		$_i18n_local = @parse_ini_file(dirname(__FILE__).'/lang/en_US.ini', true);
	
	return (isset($_i18n_local[$key]) ? $_i18n_local[$key] : '_i18n_' . $key . '_i18n_');	
}

// Returns the first image from the page content
function fsGetImage($content)
{
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/ii', $content, $matches);
    
    if (!empty($matches[1][0]))
        return $matches[1][0];

    return false;
}

function featuredImage($p,$w='100%',$h='400px',$onlySrc=false)
{
    if(!empty($p->image) && !$onlySrc) 
    { 
        return PHP_EOL.'
        <div class="featured-image">
            <a href="'.$p->url.'"><img src="'.$p->image.'" alt="'.$p->title.'" style="width:'.$w.';height:'.$h.'" /></a>
        </div>'.PHP_EOL;
    }
    else
    {
        if(empty($p->image)) return fsGetImage($p->body);
        else return $p->image;
    }
} 

function featuredVideo($p,$w='100%',$h='400')
{
    if(!empty($p->video)) 
    { 
        return PHP_EOL.'
        <div class="featured-video">
            <iframe src="https://www.youtube.com/embed/'.$p->video.'" width="'.$w.'" height="'.$h.'" frameborder="0" allowfullscreen></iframe>
        </div>'.PHP_EOL;
    }
} 

function featuredAudio($p,$w='100%',$h='200')
{
    if(!empty($p->audio)) 
    { 
        return PHP_EOL.'
        <div class="featured-audio">
            <iframe src="https://w.soundcloud.com/player/?url='.$p->audio.'&amp;auto_play=false&amp;visual=true" width="'.$w.'" height="'.$h.'" scrolling="no" frameborder="0" allowfullscreen></iframe>
        </div>'.PHP_EOL;
    }
} 

function featuredQuote($p,$w='100%',$h='200')
{
    if(!empty($p->quote)) 
    { 
        return PHP_EOL.'
        <div class="featured-quote">
            <blockquote>'.$p->quote.'</blockquote>
        </div>'.PHP_EOL;
    }
} 

function featuredLink($p)
{
    if(!empty($p->link)) 
        return '<h2 class="title-index" itemprop="name"><a href="'.$p->link.'">'.$p->title.' &rarr;</a></h2>'.PHP_EOL;
    else
        return '<h2 class="title-index" itemprop="name"><a href="'.$p->url.'">'.$p->title.'</a></h2>';
} 

function featuredGetThumb($p)
{
   if(empty($p->image))
    {   
        if(/* && config('xx') != 'true' && config('teaser.type') === 'trimmed' && */ $p->type=='post')
        {
            $thbd=fsGetImage($p->body);
            
            if($thbd)
                return '<div class="thumbnail"><img src="'.$thbd.'" alt="Thumbnail of '.$p->title.'" style="width:200px"></div>';
        }
    }
}
?>