<?php
//Plugin by @fabianosantosnet for BLUDT CMS 2020-2021

if(file_exists(PATH_PLUGINS.'_DEBUG.php')) require_once(PATH_PLUGINS.'_DEBUG.php');
require_once('_includes/_helper.php'); # name of trait was changed to avoid plugin broken

class pluginFS_SEO extends Plugin {

	public function init()
	{
		// Fields and default values for the database of this plugin
		$this->dbFields = array
		(
            # SHARED
            'is_xhtml'=>false,
            'space'=>'',
            'showPluginLateralEnabled'=>true,
            
            #FB
			'fbopenGraphEnabled'=>false,
			'fb_AppId'=>'',
            'fb_defaultImageHome'=>'',
			'fb_defaultImage'=>'',            
            'fb_defaultImageChk'=>'',
            'fb_defaultImageCat'=>'',
            'fb_defaultImageCatChk'=>false,            
            'fb_defaultImageTag'=>'',
            'fb_defaultImageTagChk'=>false,
			'fb_page'=>'',
            'fb_page_chk'=>false,
			'fb_description'=>'',
			'fb_description_category'=>'',
            'fb_description_category_chk'=>false,
			'fb_description_tag'=>'',
            'fb_description_tag_chk'=>false,
            
            #TW
            'twcardEnabled'=>false,					
            'tw_defaultImageHome'=>'',
			'tw_defaultImage'=>'',
            'tw_defaultImage_chk'=>'',
            'tw_defaultImageCategory'=>'',
            'tw_defaultImageCategory_chk'=>false,
            'tw_defaultImageTag'=>'',
            'tw_defaultImageTag_chk'=>false,
			'tw_def_desc'=>'',
            'tw_def_category_desc'=>'',
            'tw_def_category_desc_chk'=>false,            
            'tw_def_tag_desc'=>'',
            'tw_def_tag_desc_chk'=>false,
			'tw_def_page'=>'',
            'tw_def_page_chk'=>false,
            
            #MAP
			'sitemapEnabled'=>false,
			'pingGoogle'=>false,
			'pingBing'=>false,
            'sitemapFrequency'=>'disabled',
            'sitemapPriority'=>'disabled'
		);
        
        $this->arSitemapFrequency = array
        (
            'always',
            'hourly',
            'daily',
            'weekly',
            'monthly',
            'yearly',
            'never',
            'disabled',
            'default'
        );
        
        $this->arSitemapPriority = array
        (
            '0.0',
            '0.1',
            '0.2',
            '0.3',
            '0.4',
            '0.5',
            '0.6',
            '0.7',
            '0.8',
            '0.8',
            '1.0',
            'disabled',
            'default'
        );        
	}

	public function beforeAll()
	{
		/* SITEMAP */				
		if($this->getValue('sitemapEnabled'))
		{	
			$webhook = 'sitemap.xml';
			if( $this->webhook($webhook) )
			{
				$sitemapFile = $this->workspace().'sitemap.xml';
				$sitemapSize = filesize($sitemapFile);

				// Send XML header
				header('Content-type: text/xml');
				header('Content-length: '.$sitemapSize);

				$doc = new DOMDocument();

				// Workaround for a bug https://bugs.php.net/bug.php?id=62577
				libxml_disable_entity_loader(false);

				// Load XML
				$doc->load($this->workspace().'sitemap.xml');

				libxml_disable_entity_loader(true);

				// Print the XML
				echo $doc->saveXML();

				// Terminate the run successfully
				exit(0);
			}	
		}		
	}
	
	public function form()
	{
		global $L;

		$html  = '
				<style>					
					form.plugin-form > div:first-of-type > h2 {padding:1rem;background:#f5f5f5;border-bottom:1rem solid #ccc}
					form.plugin-form > div:first-of-type {margin-top:-0.7rem}
					form.plugin-form > div.align-middle > div {padding:1rem}
					
					div.plgopt {background:#eee;padding:1rem;text-align:right}
					div.plgopt .optionplugin {width:auto !important;display:inline-block;border-radius:0;height:auto;padding:0.1rem}
					div.inlineopt {display:inline}
					div.inlineopt div.plgopt {width:10rem;padding:0;background:transparent;display:inline}
					div.inlineopt div.plgopt .optionplugin {display:inline}
					
					.plgact_message {display:block;padding:1rem;margin:auto;width:400px;background-color:#ffe;color:red;font-size:1rem}
	
					div.plugin-info {background:#f5f5f5;padding:1rem;font-size:0.8rem !important}
					div.plugin-info h2 {padding:0.5rem 1rem;background:#eee;color:#777;text-transform:uppercase;font-size:1.2rem;font-weight:bold;margin:-1rem;margin-bottom:1rem}
					
					div.plugin-info h3.desc {background-color:#ddd;color:#777;margin:-1rem;margin-bottom:2rem;padding:2rem}					
					div.plugin-info h3 {padding:1rem;font-size:1rem}
					
					div.plugin-info div label {}
					div.plugin-info div {clear:both}
					div.plugin-info input[type=text] {border-radius:0;border-color:#ddd;padding:0.4rem;margin-top:-0.3rem;color:#999}
					div.plugin-info fieldset {border-top:0.1rem solid #ddd; border-bottom:0.1rem solid #ddd;padding-bottom:2rem}
                    
					p.copy {background:#eee;padding:1rem;margin:-1rem}
					span.copybased {display:block;font-size:0.7rem;margin-top:1rem;color:#999}
					div.plugin-info span.tip {background:#eee;padding:0.5rem 1rem;font-size:0.7rem;color:#777;margin-top:2px}
					
					.smap {margin-top:-0.2rem;margin:auto;max-width:600px;display:block}
					.smap label {background-color:#efefee;padding:1rem;color:#999}
					.smap label a {color:#999}
					.smap .tip2 {font-size:1rem !important;margin-bottom:1rem}
					.tip3 {background-color:#f0f0f0 !important;margin:auto;display:block;text-align:center;padding:1rem}
					.tip3 code {letter-spacing:1px !important;;}
                    .tip4 {text-align:left;font-size:0.8rem !important;background-color:#e0e0e0 !important;display:block;margin-bottom:2rem !important;border-bottom:1rem solid #eee}
					.smap .pingopt,.smap .glbopt {text-align:center;width:500px;margin:auto}
					.smap .pingopt .blk,.smap .glbopt .blk {background-color:#eee;max-width:49%;display:inline-block;padding:0.5rem;margin-left:1rem}
                    
					p.ptip {background-color:#e9e9e9;text-align:right;margin-top:1rem}
					p.ptip a {background-color:#e9e9e9;padding:0.5rem;color:#999;box-shadow:1px 1px 1px}
					p.ptip a:hover {box-shadow:1px 1px 1px #ddd;background-color:#eee}                   
					p.toplink a {float:right;color:#bbb}
					p.toplink a:hover {color:#777}                    
                    
					div.plugin-info .w100 {width:100px}
					div.plugin-info .inline {display:inline}
					#spinfo {background:#eee;padding:0.3rem}				
				</style>
				
				<script>
				window.onload=function()
				{
					function AddSpace()
					{
						var val=parseInt(document.getElementById("spaceinfo").innerHTML);
							val=val+1;
							
							if(val>100) return;
							
						document.getElementById("spaceinfo").innerHTML=val;
						document.getElementById("space").value=document.getElementById("space").value+" ";
					}
					
					function SubSpace()
					{
						var val=parseInt(document.getElementById("spaceinfo").innerHTML);
							val=val-1;
							
							if(val<0) return;
							
						document.getElementById("spaceinfo").innerHTML=val;
						
						sp="";
						for(i=0;i<val;i++) 
							sp+=" ";
						
						document.getElementById("space").value=sp;
					}					
					
					document.getElementById("spaceinfo").innerHTML="'.strlen($this->getValue('space')).'";
					document.getElementById("btnAddSpace").onclick=AddSpace;
					document.getElementById("btnSubSpace").onclick=SubSpace;
				}
				</script>
				
		<div class="plugin-info">
		<h2>'.$L->get('share-configl-name').'</h2>
		<h3 class="desc">'.$L->get('share-configl-description').'</h3>';
		
        $toplink='<p class="toplink"><a href="#top">[top]</a></p>';
        
		$html.='<div>';
		$html.=   $L->get('share-configl-space-desc');
		$html.='  <input type="button" name="btnSubSpace" id="btnSubSpace" value="-"> ';
		$html.='  <input type="button" name="btnAddSpace" id="btnAddSpace" value="+">';		
		$html.='  <span id="spinfo"><span id="spaceinfo">0</span> '.$L->get('space(s) added').'</span>';
		$html.='  <input type="hidden" id="space" name="space" value="'.$this->getValue('space').'">';
		$html.='</div><br>';
		
		$html.= '<div>';
		$html.= $L->get('share-configl-xhtml-desc');
		$html.= '<div class="inlineopt">'.$this->OptionDisableEnable('is_xhtml',false).'</div>';
		$html.= '</div>';
		$html.= '<br>';
        
        $html.= '<div>';
        $html.= $L->get('shared-configl-showplglateral-desc');
        $html.= '   <div class="inlineopt">'.$this->OptionDisableEnable('showPluginLateralEnabled',false).'</div>';
        $html.= '   </div>';
        $html.= '<br><hr>';        
        
		$html.='<div class="plugin-info">';
		$html.='<h2>Facebook OpenGraph</h2>
				<h3 class="desc">'.$L->get('fb-info-desc').'</h3>';

		  if ( getPlugin('pluginOpenGraph') ) { $html.= "<span class='plgact_message'>".$L->get('plg-opengraph-already-running')."</span>";}
		  else $html.=  $this->OptionDisableEnable('fbopenGraphEnabled');
		
        # INI FB IMAGE DEFAULT
		$html .= '<br><fieldset><span class="tip tip4">'.$L->get('fb-default-image-home-tip') .' </span><div>';
		$html .= '  <label>' . $L->get('fb-default-image-home') . '</label>';
		$html .= '  <input id="jsfb_defaultImageHome" name="fb_defaultImageHome" type="text" value="' . $this->getValue('fb_defaultImageHome') . '" placeholder="https://">';				
		$html .= '</div><br>';

        $html .= '<div>';
		$html .= '  <label>' . $L->get('fb-default-image') . '</label>';
		$html .= '  <input id="jsfb_defaultImage" name="fb_defaultImage" type="text" value="' . $this->getValue('fb_defaultImage') . '" placeholder="https://">';		
		$html .= '  <span class="tip">'.$this->OptionCheckBox('fb_defaultImageChk'). $L->get('fb-default-image-tip') .' </span>';
		$html .= '</div><br>';
		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-default-image-category') . '</label>';
		$html .= '  <input id="jsfb_defaultImageCat" name="fb_defaultImageCat" type="text" value="' . $this->getValue('fb_defaultImageCat') . '" placeholder="https://">';				
        $html .= '  <span class="tip">'.$this->OptionCheckBox('fb_defaultImageCatChk'). $L->get('fb-default-image-category-tip') .' </span>';
		$html .= '</div><br>';

		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-default-image-tag') . '</label>';
		$html .= '  <input id="jsfb_defaultImageTag" name="fb_defaultImageTag" type="text" value="' . $this->getValue('fb_defaultImageTag') . '" placeholder="https://">';				
        $html .= '  <span class="tip">'.$this->OptionCheckBox('fb_defaultImageTagChk'). $L->get('fb-default-image-tag-tip') .' </span>';
		$html .= '</div></fieldset><br>';        
		# END FB IMAGE DEFAULT
        
		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-description') . '</label>';
		$html .= '  <input id="jsfb_description" name="fb_description" maxlength="200" type="text" value="' . $this->getValue('fb_description') . '" >';
		$html .= '  <span class="tip">'. $L->get('fb-description-tip') .'</span>';
		$html .= '</div>';
		
		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-description-category') . '</label>';
		$html .= '  <input id="jsfb_description_category" name="fb_description_category" maxlength="200" type="text" value="' . $this->getValue('fb_description_category') . '" >';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('fb_description_category_chk') . $L->get('fb-description-category-tip') .'</span>';
		$html .= '</div>';

		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-description-tag') . '</label>';
		$html .= '  <input id="jsfb_description_tag" name="fb_description_tag" maxlength="200" type="text" value="' . $this->getValue('fb_description_tag') . '" >';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('fb_description_tag_chk') . $L->get('fb-description-tag-tip') .'</span>';
		$html .= '</div><br><hr>';
        
		$html .= '<div>';
		$html .= '  <label>' . $L->get('fb-page') . '</label>';
		$html .= '  <input id="jsfb_page" name="fb_page" type="text" value="' . $this->getValue('fb_page') . '" placeholder="https://www.facebook.com/USERNAME">';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('fb_page_chk'). $L->get('fb-page-tip') .'</span>';
		$html .= '</div>';
        
        $html .= '<div>';
		$html .= '  <label>' . $L->get('fb-app-id') . '</label>';
		$html .= '  <input id="jsfb_AppId" name="fb_AppId" type="text" value="' . $this->getValue('fb_AppId') . '"  placeholder="App ID">';
        $html .= '  <span class="tip">'. $L->get('fb-app-id-tip') .' </span>';
		$html .= '</div>';
		
		$html .= '<br>'.$toplink.'<br><br><br>';
		
		$html .= '<div>';
		$html .= '  <h2>Twitter Cards</h2>';
		$html .= '<h3 class="desc">'.$L->get('tw-info-desc').'</h3>';		
		
		  if ( getPlugin('pluginTwitterCards') ) { $html.= "<span class='plgact_message'>".$L->get('plg-twcard-already-running')."</span>";}
		  else $html.= $this->OptionDisableEnable('twcardEnabled');
				
		$html .= '<br>';
        $html .= '<fieldset><span class="tip tip4">'. $L->get('tw-image-home-tip') .'</span>';#general tip
        $html .= '<div>';
		$html .= '  <label>'.$L->get('tw-default-image-home').'</label>';
		$html .= '  <input id="jstw_defaultImageHome" name="tw_defaultImageHome" type="text" value="'.$this->getValue('tw_defaultImageHome').'" placeholder="https://">';
		$html .= '  ';
		$html .= '</div>';
        
        $html .= '<div>';
		$html .= '  <label>'.$L->get('tw-default-image').'</label>';
		$html .= '  <input id="jstw_defaultImage" name="tw_defaultImage" type="text" value="'.$this->getValue('tw_defaultImage').'" placeholder="https://">';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('tw_defaultImage_chk'). $L->get('tw-image-tip') .'</span>';
		$html .= '</div>';	

		$html .= '<div>';		
		$html .= '  <label>'.$L->get('tw-default-image-category').'</label>';
		$html .= '  <input id="jstw_defaultImageCategory" name="tw_defaultImageCategory" type="text" value="'.$this->getValue('tw_defaultImageCategory').'" placeholder="https://">';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('tw_defaultImageCategory_chk'). $L->get('tw-image-category-tip') .'</span>';
		$html .= '</div>';	

		$html .= '<div>';		
		$html .= '  <label>'.$L->get('tw-default-image-tag').'</label>';
		$html .= '  <input id="jstw_defaultImageTag" name="tw_defaultImageTag" type="text" value="'.$this->getValue('tw_defaultImageTag').'" placeholder="https://">';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('tw_defaultImageTag_chk'). $L->get('tw-image-tag-tip') .'</span>';
		$html .= '</div>';	
        $html .= '</fieldset>';

        
		$html .= '<div>';
		$html .= '  <label>' . $L->get('tw-default-description') . '</label>';
		$html .= '  <input id="jstw_def_desc" name="tw_def_desc" maxlength="200" type="text" value="' . $this->getValue('tw_def_desc') . '" >';
		$html .= '  <span class="tip">'. $L->get('tw-default-description-tip') .'</span>';
		$html .= '</div>';

		$html .= '<div>';
		$html .= '  <label>' . $L->get('tw-default-category-description') . '</label>';
		$html .= '  <input id="jstw_def_category_desc" name="tw_def_category_desc" maxlength="200" type="text" value="' . $this->getValue('tw_def_category_desc') . '" >';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('tw_def_category_desc_chk'). $L->get('tw-default-category-description-tip') .'</span>';
		$html .= '</div>';
		
		$html .= '<div>';
		$html .= '  <label>' . $L->get('tw-default-tag-description') . '</label>';
		$html .= '  <input id="jstw_def_tag_desc" name="tw_def_tag_desc" maxlength="200" type="text" value="' . $this->getValue('tw_def_tag_desc') . '" >';
		$html .= '  <span class="tip">'.$this->OptionCheckBox('tw_def_tag_desc_chk'). $L->get('tw-default-tag-description-tip') .'</span>';
		$html .= '</div><br><hr>';
		
		$html .= '<div>';
		$html .= '  <label>' . $L->get('tw-default-page') . '</label>';
		$html .= '  <input id="jstw_def_page" name="tw_def_page" type="text" value="' . $this->getValue('tw_def_page') . '" placeholder="https://twitter.com/USERNAME">';
		$html .= '  <span class="tip">'. $this->OptionCheckBox('tw_def_page_chk'). $L->get('tw-page-tip') .'</span>';
		$html .= '</div>';
		
		$html .= '</div><br>'.$toplink.'<br><br><br>';		

		$html .= '<h2>'.$L->get('sitemap-title').'</h2>
		<h3 class="desc">'.$L->get('sitemap-description').'</h3>';
		  
		if ( getPlugin('pluginSitemap') ) { $html.= "<span class='plgact_message'>".$L->get('plg-sitemap-already-running')."</span>";} 
		else $html.=  $this->OptionDisableEnable('sitemapEnabled');		
		
		$html .= '<br><div class="smap">';
		
		$html .= '  <span class="tip tip2">'.$L->get('ping-tip').'</span>';
		
		$html .= '  <div class="pingopt">
                        <div class="blk">'.$L->get('Ping Google');		
		$html.=  '          <div class="inlineopt">'.$this->OptionDisableEnable('pingGoogle',false).'</div>
                        </div>';
		
        $html .= '      <div class="blk">'.$L->get('Ping Bing');	
        $html.=  '          <div class="inlineopt">'.$this->OptionDisableEnable('pingBing',false).'</div>
                        </div>';
                             
        $html.='   </div><br><hr>';		        
        
        
        $html .= '<span class="tip tip2">'.$L->get('fs-seo-sitemap-opt-title').'</span>';		
        
		$html .= '<div class="glbopt">
                    <div class="blk">'.$L->get('fs-seo-sitemap-frequency-lbl');		                
        $html.=  '      <div class="inlineopt">'.$this->Option($this->arSitemapFrequency,'sitemapFrequency').'</div>
                    </div>';
        
		$html .= '  <div class="blk">'.$L->get('fs-seo-sitemap-priority-lbl');	
		$html.=  '      <div class="inlineopt">'.$this->Option($this->arSitemapPriority,'sitemapPriority').'</div>
                    </div><br><br>';		
        
        $html.='    <span class="tip">'.$L->get('fs-seo-sitemap-opt-tip').'</span>
                </div><br>';
        
		$html .= '<p class="ptip"><a href="'.DOMAIN_BASE.'sitemap.xml" target="_blank">SITEMAP</a></p>';
		$html .='</div>'.$toplink.'<br>';		
		
		$html.='<br><hr><br><span class="tip3">'.$L->get('replace-info').'</span><br><br>';
		
		$spc='&nbsp;&nbsp;&nbsp;';
		$html.='<p class="copy">'.$spc.'FS SEO Plugin for BLUDIT CMS by @fabianosantosnet. '.$L->get('send-me-tip').'<br>';
		$html.='<span class="copybased">'.$spc.'This was based on BLUSEO, Twitter Card and OpenGraph Plugins</span></p><br>';
						
						/* Some parts are improvement of  BluSEO plugin https://bit.ly/38Pji2K (Thank you!) */
						
		$html .= '</div>';
		
		return $html;
	}

	public function siteHead()
	{ 
		#fix global names
		global $url;
		global $site;
		global $WHERE_AM_I;
		global $pages;
		global $page;
		$SPACE = '';
		$html =  '';
		
		// Spaces
		if( $this->getValue('space') )
			$SPACE=$this->getValue('space');		
		
		//Default Values
		$og = array
		(
			'lang'		=> $site->language()
		);

		if( $WHERE_AM_I == 'page' )
		{		
			$usr = $page->username() ?? 'admin';			
			$user2 = new User($usr);	 #check if the article has a profile
            
			$twt   = $user2->twitter() ?? $site->twitter();		# if profile is not available than use sites profile
			
            if( $this->getValue('tw_def_page_chk') ) $twt=strip_tags(htmlentities($this->getValue('tw_def_page'))); #replace with default
            else if(empty($twt)) $twt=$this->getValue('tw_def_page'); #if none exist than use the default value
			
			$og['twitteruser']=substr( str_replace('https://twitter.com/','@',$twt) , 0, 16);  #limited chars by login size            
			
			$og['type']			= 'article';
			$og['title']		= $page->title() . ' | ' . $site->title();
			$og['description']	= $this->limitText( $this->getDescription('fb_description',true) ,200); #FB	
			
			$og['url']			= $page->permalink($absolute=true);			
			$og['image'] 		= $this->getValue('fb_defaultImageChk') ? $this->getImageURL('fb_defaultImage',true) : $this->getImageURL('fb_defaultImage');
			
			#Twitter
            $og['imagetw'] 			= $this->getValue('tw_defaultImage_chk') ? $this->getImageURL('tw_defaultImage',true) : $this->getImageURL('tw_defaultImage');
			$og['descriptiontw']	= $this->getDescription('tw_def_desc',true); #TW			
			
		}
		elseif( $WHERE_AM_I == 'category' )
		{			
			$og['type']			= 'website';
			$og['title']		= $site->slogan() . ' | ' . $site->title();
			$og['description']	= $this->getValue('fb_description_category_chk') ? $this->getCategoryDescription('fb_description_category') : $this->getDescription('fb_description_category',true);
			$og['image']		= $this->getValue('fb_defaultImageCatChk') ? $this->getImageURL('fb_defaultImageCat',true) : $this->getImageURL('fb_defaultImageCat');  
            
            $catKey = $url->slug();
            $cat = new Category($catKey);            
			$og['url']			= $cat->permalink();
            
			# Twitter            
			$og['descriptiontw']= $this->getValue('tw_def_category_desc_chk') ? $this->getCategoryDescription('tw_def_category_desc') : $this->getDescription('tw_def_category_desc',true);
			$og['imagetw']	    = $this->getValue('tw_defaultImageCategory_chk') ? $this->getImageURL('tw_defaultImageCategory',true) : $this->getImageURL('tw_defaultImageCategory');
		}
		elseif( $WHERE_AM_I == 'tag' )
		{			
			$og['type']			= 'website';
			$og['title']		= $site->slogan() . ' | ' . $site->title();			
            $og['description']	= $this->getValue('fb_description_tag_chk') ? $this->getDescription('fb_description_tag') : $this->getDescription('fb_description_tag',true);
			$og['image']		= $this->getValue('fb_defaultImageTagChk') ? $this->getImageURL('fb_defaultImageTag',true) : $this->getImageURL('fb_defaultImageTag');
            
            $tagKey = $url->slug();
            $tag = new Tag($tagKey);            
			$og['url']			= $tag->permalink();
			
			# Twitter
			$og['descriptiontw']= $this->getValue('tw_def_tag_desc_chk') ? $this->getDescription('tw_def_tag_desc') : $this->getDescription('tw_def_tag_desc',true);
			$og['imagetw']	    = $this->getValue('tw_defaultImageTag_chk') ? $this->getImageURL('tw_defaultImageTag',true) : $this->getImageURL('tw_defaultImageTag');                      
		}
		elseif( $WHERE_AM_I == 'home' )
		{			
        	$og['type']			= 'website';
			$og['title']		= $site->slogan() . ' | ' . $site->title();			
            $og['description']  = $site->description();
            $og['descriptiontw']= $site->description();
            $og['image']        = strip_tags($this->getValue('fb_defaultImageHome'));
            $og['imagetw']      = strip_tags($this->getValue('tw_defaultImageHome'));
            $og['url']			= $site->url();
            //ignored other types of page like search
		}
		
		if( $this->getValue('fbopenGraphEnabled') && !$url->notFound() )
		{
            if( $WHERE_AM_I == 'page' || $WHERE_AM_I == 'category' || $WHERE_AM_I == 'tag'  || $WHERE_AM_I == 'home' ) #avoid other types of 'places'
            {
                $html=PHP_EOL;			
                $html .= $SPACE.'<meta property="og:locale" content="' . $site->locale() . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="og:type" content="' . $og['type'] . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="og:title" content="' . htmlspecialchars( $og['title'], ENT_QUOTES ) . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="og:description" content="' . htmlspecialchars( $og['description'], ENT_QUOTES ) . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="og:url" content="' . $og['url'] . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="og:site_name" content="' . htmlspecialchars( $site->title(), ENT_QUOTES ) . '">' . PHP_EOL;
                
                if (Text::isNotEmpty($this->getValue('fb_AppId')))
                    $html .= $SPACE.'<meta property="fb:app_id" content="'. $this->getValue('fb_AppId').'">'.PHP_EOL;
			}
            
			if( $WHERE_AM_I == 'page' )
			{
                if( $this->getValue('fb_page_chk') )
                {
                    if(strlen($this->getValue('fb_page'))>0)
                        $fbp = htmlspecialchars(strip_tags($this->getValue('fb_page')),ENT_QUOTES);
                }
                
                if(empty($fbp))
                    $fbp = $user2->facebook() ? $user2->facebook() : $site->facebook();
				
				if($fbp)
					$html .= $SPACE.'<meta property="article:publisher" content="' . $fbp . '">' . PHP_EOL;
				
				else if ( Text::isNotEmpty( $this->getValue('fb_page') ) )
					$html .= $SPACE.'<meta property="article:publisher" content="' . $this->getValue('fb_page') . '">' . PHP_EOL;
				
				$cat = $page->categoryMap(true);
				
				$tags = $page->tags(true);
				
				if ( !empty($tags) )
				{
					foreach($tags as $tagKey=>$tagName)
						$html .= $SPACE.'<meta property="article:tag" content="' . htmlspecialchars( $tagName, ENT_QUOTES ) . '">' . PHP_EOL;
				}
				
				if ( Text::isNotEmpty($cat) )
				{
					$html .= $SPACE.'<meta property="article:section" content="' . ucwords( str_replace( '-', ' ', $cat ) ) . '">' . PHP_EOL;
				}
				
				$html .= $SPACE.'<meta property="article:published_time" content="' . date('c', strtotime($page->dateRaw())) . '">' . PHP_EOL;
				
                # bug return formated date when print '$page->dateModified()' because it is defined in format date on general->language
                $rawModifiedDate=$page->getValue('dateModified');
                
				if ( Text::isNotEmpty($rawModifiedDate) ) 
				{                
					$html .= $SPACE.'<meta property="article:modified_time" content="' . date('c', strtotime( $rawModifiedDate )) . '">' . PHP_EOL;
					$html .= $SPACE.'<meta property="og:updated_time" content="' . date('c', strtotime( $rawModifiedDate )) . '">' . PHP_EOL;
				}						
			}
			#END PAGE
			
			#INI image
			if (!empty($og['image']))
			{				
				$html .= $SPACE.'<meta property="og:image" content="' . $og['image'] . '">' . PHP_EOL;
				
				if ( substr( $og['image'], 0, 8 ) == "https://" )
					$html .= $SPACE.'<meta property="og:image:secure_url" content="' . $og['image'] . '">' . PHP_EOL;
		
				list($img_width, $img_height) = @getimagesize($og['image']);
				
				if ( !empty($img_width) && !empty($img_height) )
				{
					$html .= $SPACE.'<meta property="og:image:width" content="' . $img_width . '">' . PHP_EOL;
					$html .= $SPACE.'<meta property="og:image:height" content="' . $img_height . '">' . PHP_EOL;
				}				
			} 	
			
			if( !$this->getValue('twcardEnabled') ) $html.=PHP_EOL;
		}
		#END FB
		
		if(!$this->getValue('fbopenGraphEnabled')) $html='';
		
		if( $this->getValue('twcardEnabled') && !$url->notFound() )
		{	
            if( $WHERE_AM_I == 'page' || $WHERE_AM_I == 'category' || $WHERE_AM_I == 'tag' || $WHERE_AM_I == 'home' ) #avoid other types of 'places'
            {
                if(!empty( $og['imagetw'] ) )
                  $html .= PHP_EOL.$SPACE.'<meta property="twitter:card" content="summary_large_image">' . PHP_EOL;			
                else
                  $html .= $SPACE.'<meta property="twitter:card" content="summary">' . PHP_EOL;			
            
                $html .= $SPACE.'<meta property="twitter:site" content="'.$site->title().'">'.PHP_EOL; 
                
                if(!empty( $og['twitteruser']) ) $html .= $SPACE.'<meta property="twitter:creator" content="'.$og['twitteruser'].'">' . PHP_EOL; #ADDED			
                
                $html .= $SPACE.'<meta property="twitter:description" content="' . $this->limitText(htmlspecialchars( $og['descriptiontw'], ENT_QUOTES ),200) . '">' . PHP_EOL;
                $html .= $SPACE.'<meta property="twitter:title" content="' . $this->limitText(htmlspecialchars( $og['title'],70)) . '">' . PHP_EOL;   #limited to 70 characters https://bit.ly/36uxEIh		
                
                if(!empty( $og['imagetw'] ) ) $html .= $SPACE.'<meta property="twitter:image" content="' . $og['imagetw'] . '">' . PHP_EOL;
                
                $html.=PHP_EOL;			
            }
		}
		# XML / XTML Tag
		if( $this->getValue('is_xhtml') )
			$html=str_replace('">','" />',$html);
		
		return $html;
	}
	
	/* SITEMAP */	
	private function sitemap_createXML()
	{
		global $site;
		global $pages;

		$xml = '<?xml version="1.0" encoding="UTF-8" ?>';
		$xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

		$xml .= '<url>';
		$xml .= '<loc>'.$site->url().'</loc>';
        
        if($this->getValue('sitemapFrequency') && $this->getValue('sitemapFrequency') != 'disabled')
            $xml .= '<priority>1.0</priority>'; #default value for principal link
        
		$xml .= '</url>';

		$list = $pages->getList($pageNumber=0, $numberOfItems=-1, $published=true, $static=true, $sticky=true, $draft=false, $scheduled=false);
        
		foreach ($list as $pageKey)
        {
			try 
            {
				// Create the page object from the page key
				$page = new Page($pageKey);
                
				if (!$page->noindex()) //Ignore noindex pages
                {
					$xml .= '<url>';
					$xml .= '<loc>'.$page->permalink().'</loc>';
					$xml .= '<lastmod>'.$page->date(SITEMAP_DATE_FORMAT).'</lastmod>';
                    
                    if($this->getValue('sitemapFrequency') && $this->getValue('sitemapFrequency') != 'disabled')
                    {
                        if($this->getValue('sitemapFrequency') =='default')
                        {
                             switch($page->type())
                            {
                                case 'static':
                                    $xml .= '<changefreq>monthly</changefreq>';                                   
                                break;
                                
                                case 'sticky':
                                    $xml .= '<changefreq>daily</changefreq>';
                                break;
                                
                                case 'published':                                
                                    $xml .= '<changefreq>weekly</changefreq>';
                                break;
                            }
                        }
                      else
                          $xml .= '<changefreq>'.$this->getValue('sitemapFrequency').'</changefreq>';
                    }
                    
                    if($this->getValue('sitemapPriority') && $this->getValue('sitemapPriority') != 'disabled')
                    {
                        if($this->getValue('sitemapPriority') =='default')
                        {    
                            switch($page->type())
                            {
                                case 'static':
                                    $xml .= '<priority>0.9</priority>';                                    
                                break;
                                
                                case 'sticky':
                                    $xml .= '<priority>0.8</priority>';
                                break;
                                
                                case 'published':                                
                                    $xml .= '<priority>0.7</priority>';
                                break;
                            }
                        }                        
                        else
                            $xml .= '<priority>'.$this->getValue('sitemapPriority').'</priority>';
                    }    
                                        
					$xml .= '</url>';
				}
			}
            catch (Exception $e)
            {
			 // Continue
			}
		}

		$xml .= '</urlset>';

		// New DOM document
		$doc = new DOMDocument();
		$doc->formatOutput = true;
		$doc->loadXML($xml);
		return $doc->save($this->workspace().'sitemap.xml');
	}

	private function sitemap_ping()
	{
		if ($this->getValue('pingGoogle')) {
			$url = 'https://www.google.com/ping?sitemap='.DOMAIN_BASE.'sitemap.xml';
			TCP::http($url, 'GET', true, 3);
		}

		if ($this->getValue('pingBing')) { #BING and Yahoo are partners - they use the same engine | Qwant and duckduckgo also use their results
			$url = 'https://www.bing.com/ping?sitemap='.DOMAIN_BASE.'sitemap.xml';
			TCP::http($url, 'GET', true, 3);
		}
	}

    public function adminSidebar()
    {   
		if( $this->getValue('showPluginLateralEnabled') )	
		{
			return '<li class="nav-item"><a class="nav-link" href="' . HTML_PATH_ADMIN_ROOT . 'configure-plugin/'.get_class($this).'">' .$this->name(). '</a></li>';
		}
    }
    
	public function install($position=0)
	{
		parent::install($position);
		return $this->sitemap_createXML();
	}

	public function post()
	{
		parent::post();
		
		if($this->getValue('sitemapEnabled'))
		  return $this->sitemap_createXML();
	}

	private function callCreateXMLPING()
	{
		if($this->getValue('sitemapEnabled'))
		{
		  $this->sitemap_createXML();
		  $this->sitemap_ping();
		}
	}
	
	public function afterPageCreate()
	{
		$this->callCreateXMLPING();
	}

	public function afterPageModify()
	{
		$this->callCreateXMLPING();
	}

	public function afterPageDelete()
	{
		$this->callCreateXMLPING();
	}	
        	
	# include utils functions by trait on includes
	use FS_Utils_FS_SEO;
}