<?php
trait FS_Utils_FS_SEO
{	
    # UTILS FUNCTIONS	
	private function Option($arList, $var)
	{
		global $L;
		
		$html  = '<div class="plgopt">';
		$html .= '<select name="'.$var.'" class="optionplugin">'.PHP_EOL;
		
		foreach($arList as $l)
		{
			$selected='';
			
			if($this->getValue($var)===$l)								
			 $html.= '<option selected value="'.$this->getValue($var).'">'. ucfirst( $L->get($this->getValue($var)) ).'</option>'.PHP_EOL;
		    else
			  $html.= '<option value="'.$l.'">'.ucfirst( $L->get($l) ).'</option>'.PHP_EOL;
		}
		
		$html.='</select>'.PHP_EOL;
		
		$html.= '</div>'.PHP_EOL;
		
		return $html;
	}
	
	private function OptionCheckBox($var)
	{
		$ck = ( $this->getValue($var) ? ' checked' : '' );	
		
		return PHP_EOL."<input type=\"hidden\" name=\"$var\" id=\"hidden_$var\" value=\"0\">".PHP_EOL.
		"<input type=\"checkbox\" name=\"$var\" id=\"$var\" value=\"1\"$ck>".PHP_EOL;		
	}
	
	private function InputTxt($var, $value=false, $class=false)
	{	
		if($value) $value=" value=\"$value\"";
		
		if($class) $class=" class=\"$class\"";
		
		return "<input type=\"text\" name=\"$var\" id=\"$var\"$class$value>";		
	}	
	
	private function Textarea($var, $value=false, $class=false)
	{	
		if($class) $class=" class=\"$class\"";
		
		return "<textarea name=\"$var\" id=\"$var\"$class>$value</textarea>";		
	}		
	
	// Return the description with fallback
	private	function getDescription($id,$article=false)
	{
		global $site, $page;
		
		if($article) 
		{
			if( Text::isNotEmpty ( $page->description() ) )
				return $page->description();
		}
		
		if( Text::isNotEmpty ( $this->getValue( $id ) ) )
		 return $this->getValue( $id );
		else 
		  return $site->description();			
	}	
	
    private	function getCategoryDescription($id)
	{
		global $site, $page;
        
       // Check if the user is browsing a category
        if ( Text::isNotEmpty ($page->category()) )
        {
            // Get the category key from the URL
             $categoryKey = strtolower($page->category());

            // Create the Category-Object
            $category = new Category($categoryKey);

            // Print the category description            
            if(!empty($category->description()))
                return $category->description(); 
            else
                return $this->getDescription($id);    
        }        
		else
            return $this->getDescription($id);
	}	
	
    
	private function CheckIfPageExists()
	{
		#copy from Bludits configs
		$decode = urldecode($_SERVER['REQUEST_URI']); 				
		$explode = explode('?', $decode);
		$uril = basename($explode[0]);	
		
		#defined in functions.php on bl-kernel
		if(buildPage($uril))
			return true;
		else 
			return false;
	}		

    // strip tags to avoid breaking any html
    #  https://stackoverflow.com/questions/4258557/limit-text-length-in-php-and-provide-read-more-link
    private function limitText($string,$size=150)
    {
        $string = strip_tags($string,$size);
        
        if (strlen($string) > $size)
        {        
            // truncate string
            $stringCut = substr($string, 0, $size);
            $endPoint = strrpos($stringCut, ' ');
        
            //if the string doesn't contain any space then it will cut without word basis.
            $string = $endPoint ? substr($stringCut, 0, $endPoint) : substr($stringCut, 0);
            if($string) $string .= '...';
        }
        
        return $string;
    }
    
	private function OptionDisableEnable($var,$showstatus=true)
	{
		global $L;
		
		$html= '<div class="plgopt">';
		
		if($showstatus) $html.= '<span>'.$L->get('Plugin Status').'</span>';
		
		$html.= '
				<select name="'.$var.'" class="optionplugin">
					 <option value="true" '.($this->getValue($var)===true?'selected':'').'>'.$L->get('Enabled').'</option>
					 <option value="false" '.($this->getValue($var)===false?'selected':'').'>'.$L->get('Disabled').'</option>
				</select>';
				
		$html.= '</div>';
		
		return $html;
	}
	
	// Returns the first image from the page content
	private function getImage($content)
	{
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/ii', $content, $matches);
		
		if (!empty($matches[1][0]))
			return $matches[1][0];

		return false;
	}
	
	// Return the image with fallback
	private function getImageURL($id,$default=false)
	{
		global $page;
		
		$img='';
		
		if($page && !$default)
		{
			$img=$page->coverImage(true);
					
			if(empty($img))
			{				
				$img = $this->getImage($page->content());
			
				if(empty($img))
					$img=$this->getValue($id);
			}			
		}
		else
		{
			$img=$this->getValue($id);
		}
			
		return $img;
	}    
}
?>