<?php
//Plugin by @fabianosantosnet for BLUDIT CMS 2021

if(file_exists(PATH_PLUGINS.'_DEBUG.php')) require_once(PATH_PLUGINS.'_DEBUG.php');
require_once('_includes/_helpers.php'); # name of trait changed to avoid broke plugin

class pluginFS_PageMenu extends Plugin 
{
    public const SEPARATORFS='[|FS|]';
    	
	public function init()
	{
		// Fields and default values for the database of this plugin
		$this->dbFields = array
		(
			'space'=>'',
			'showPluginLateralEnabled'=>true,            
            'removeSpaces'=>false,
            'hideEntryHTMLBlocks'=>false,
            'updateDefaultViewJS'=>true,
            'ActiveTabDefault'=>0,
            'OrderSubPlugins'=>'0,1,2',
            
            'fs_PageMenu_LinksEnabled'=>false,
            'fs_PageMenu_LinksHeaderTitle'=>'Links',
            'fs_PageMenuLinksChkRemDefaultsTags'=>false,
            'fs_PageMenuLinksLocationSelected'=>'siteSidebar',
            'fs_PageMenu_LinksMultiple'=>'',
            
            'fs_PageMenu_NavigationEnabled'=>false,
            'fs_PageMenu_NavigationHeaderTitle'=>'Navigation',
            'fs_PageMenuNavigationChkAddHomeLink'=>false,
            'fs_PageMenuNavigationChkRemDefaultsTags'=>false,
            'fs_PageMenuNavigationChkChildPages'=>false,
            'fs_PageMenu_NavigationCountLimit'=>5,
            'fs_PageMenuNavigationLocationSelected'=>'siteSidebar',
            'fs_PageMenu_NavigationRemPages'=>'',
            
            'fs_PageMenu_StaticEnabled'=>false,
            'fs_PageMenu_StaticHeaderTitle'=>'Static Pages',
            'fs_PageMenu_StaticLocationSelected'=>'siteSidebar',
            'fs_PageMenu_StaticCountLimit'=>5,
            'fs_PageMenu_StaticChkAddHomeLink'=>false,
            'fs_PageMenu_StaticChkRemDefaultsTags'=>false,
            'fs_PageMenu_StaticChkChildPages'=>false
		);		
		
		$this->arLocations = array
		(
			'siteSidebar',
			'pageBegin',
			'pageEnd',
			'siteBodyBegin',
			'siteBodyEnd'
		);
        
        # Used here because dbField doesnt support array within array
        $this->arDefault_plugins=array
        ( 
            0=>"fs-page-menu-links-title",
            1=>"fs-page-menu-navigation-title",
            2=>"fs-page-menu-static-title"
        );        
        
		// Disable default Save and Cancel button
		$this->formButtons = false; 
	}

    public function adminHead()
	{   
        global $L;
        
        $pluginBluditVersionInstalled=$this->version(); 
        $jsonNamePlugin=$this->name();       
        $jsonNamePlugin=str_replace(" ","-",strtolower($jsonNamePlugin)); 

        include('_includes/jsupdateplugin.php');
        
        $dir=$this->directoryName();
        
        echo '<script src="https://polyfill.io/v3/polyfill.js"></script>'.PHP_EOL.
             '<script src="'.DOMAIN.HTML_PATH_PLUGINS.$dir.'/_includes/external/html5sortable.min.js"></script>'.PHP_EOL;
    }
    
	public function form()
	{
		global $L;
		$html='';
        $ActiveTabDefault=$this->getValue('ActiveTabDefault');
        
        echo '<style>';
		include('_includes/css.php');
        echo '</style>';

        include('_includes/jsbase.php');
        include('_includes/jsplgs.php');
        
		echo '<div id="plgall">';		
		include('_includes/sharedconfig.php');
		
		include('_includes/forms.php');		
		
		include('_includes/footer.php');				
		echo '</div>';
	}
		
    public function adminSidebar()
    {
        global $login;
        
		if( $this->getValue('showPluginLateralEnabled') && $login->role() === 'admin' )	
		{
            $name=str_replace(" ","-",strtolower($this->name()));
			return '<li class="nav-item"><a class="nav-link" id="link-update-plg-'.$name.'" href="' . HTML_PATH_ADMIN_ROOT . 'configure-plugin/'.get_class($this).'">' .$this->name(). '</a></li>';
		}
    }
    
    private function PageMenuLinks()
    {   
		global $L;
        $html='';                
        $sp=$this->getValue('space');
        
        $html.= PHP_EOL.$sp.'<div class="fs-page-menu-links">'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenuLinksChkRemDefaultsTags')) $html.=$sp.'  <div class="plugin plugin-page-menu-links">'.PHP_EOL;
        
        # show title only if its not empty
        if(!empty($this->getValue('fs_PageMenu_LinksHeaderTitle')))
            $html.=$sp.'   <h2 class="plugin-label">'.$this->getValue('fs_PageMenu_LinksHeaderTitle').'</h2>'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenuLinksChkRemDefaultsTags')) $html.=$sp.'    <div class="plugin-content">'.PHP_EOL;
                
        $html .= $sp.'      <ul>'.PHP_EOL;
        
        // Get the JSON DB, getValue() with the option unsanitized HTML code
        $lksdb= Sanitize::htmlDecode($this->db['fs_PageMenu_LinksMultiple']);
        $arLinks=json_decode($lksdb ,true);
        
        if(gettype($arLinks) != 'NULL')
        {
            if(count($arLinks)>0)
            {
                foreach($arLinks as $indice=>$string)
                {
                  list($link,$name)=explode(self::SEPARATORFS,$string);
                  $html .= $sp.'        <li><a href="'.$link.'">'.$name.'</a></li>'.PHP_EOL;
                }
            }
        }
        
        $html .= $sp.'      </ul>'.PHP_EOL;
        
        if(!$this->getValue('fs_PageMenuLinksChkRemDefaultsTags')) $html.=$sp.'    </div>'.PHP_EOL;#end content
        
        if(!$this->getValue('fs_PageMenuLinksChkRemDefaultsTags')) $html.=$sp.'  </div>'.PHP_EOL;#end plugin
                    
        $html.=$sp.'</div>'.PHP_EOL; #end block
        
        //remove spaces
        if( $this->getValue('removeSpaces') )  
            $html=$this->RemoveSpaces($html);
        
        return $html;
    }
    
    private function PageMenuNavigation()
    {   
		global $L, $site, $pages;
        $html='';
        $sp=$this->getValue('space');
        
        #create array
        $ignorePages=explode(',', $this->getValue('fs_PageMenu_NavigationRemPages') );        
        for($i=0;$i<count($ignorePages);$i++) #replace values only with numbers
            $ignorePages[$i]=((int) filter_var($ignorePages[$i], FILTER_SANITIZE_NUMBER_INT));
        
        $html.= PHP_EOL.$sp.'<div class="fs-page-menu-navigation">'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenuNavigationChkRemDefaultsTags')) $html.=$sp.'  <div class="plugin plugin-page-menu-navigation">'.PHP_EOL;
        
        # show title only if its not empty
        if(!empty($this->getValue('fs_PageMenu_NavigationHeaderTitle')))
            $html.=$sp.'   <h2 class="plugin-label">'.$this->getValue('fs_PageMenu_NavigationHeaderTitle').'</h2>'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenuNavigationChkRemDefaultsTags')) $html.=$sp.'    <div class="plugin-content">'.PHP_EOL;
        
        $html .= $sp.'      <ul>'.PHP_EOL;        

		// Show Home page link
		if ($this->getValue('fs_PageMenuNavigationChkAddHomeLink'))
			$html .= $sp.'        <li class="parent"><a href="' . $site->url() . '">' . $L->get('Home page') . '</a></li>'.PHP_EOL;
		
        // Pages order by position
		if (ORDER_BY=='position')
        {
			// Get parents
			$parents = buildParentPages();
            
            $i=1;
			foreach($parents as $parent)
            {    
                if($this->getValue('fs_PageMenu_NavigationCountLimit')=='0') break;
                
                if( in_array($parent->position(), $ignorePages)) continue; #= ignore current execution if it exist and call another
                 
				$html .= $sp.'        <li class="parent"><a href="' . $parent->permalink() . '">' . $parent->title() . '</a>';

				if ($parent->hasChildren() && !$this->getValue('fs_PageMenuNavigationChkChildPages'))
                {
					// Get children
					$children = $parent->children();
                    
					$html .= PHP_EOL.$sp.'                           <ul class="child">'.PHP_EOL;
                    
					foreach ($children as $child)
					  $html .= $sp.'                            <li class="child" style="margin-left:0.5rem"><a class="child" href="' . $child->permalink() . '">' . $child->title() . '</a></li>'.PHP_EOL;
                    
					$html .= $sp.'                           </ul>'.PHP_EOL.$sp.'        ';
				}
                
				$html .= '</li>'.PHP_EOL;
                
                if($i>=$this->getValue('fs_PageMenu_NavigationCountLimit') && $this->getValue('fs_PageMenu_NavigationCountLimit') != -1)
                    break;
                
                $i++;
			}
		}
		// Pages order by date
		else 
        {
			// List of published pages
			$onlyPublished  = true;
			$pageNumber     = 1;
			$numberOfItems  = $this->getValue('fs_PageMenu_NavigationCountLimit');
			$publishedPages = $pages->getList($pageNumber, $numberOfItems, $onlyPublished);

            $c=1;
			foreach ($publishedPages as $pageKey)
            {
				try 
                {
                    if($numberOfItems =='0') break;
                    
					$page = new Page($pageKey);
                    
                    if( in_array($page->position(), $ignorePages))
                    {
                        #if you remove parent page doesn't make sense see only child pages (added it too)                
                        if($page->hasChildren())
                        {
                            $children = $page->children();
                            foreach ($children as $child)
                                $ignorePages[]=$child->position();
                        }
                        
                        continue; #= ignore current execution if it exist and call another
                    }                   
                    
                    if ($page->isParent())                    
                    {
                        $html .= PHP_EOL.$sp.'        <li class="parent">';
                        $html .= '<a href="' . $page->permalink() . '">' . $page->title() . '</a>';
                    }
                    
                    if ($page->hasChildren() && !$this->getValue('fs_PageMenuNavigationChkChildPages'))
                    {   
                        $chn = $page->children();
                        
                        $html .= PHP_EOL.$sp.'                           <ul>'.PHP_EOL;
                        
                        foreach ($chn as $ch)
                          $html .= $sp.'                            <li class="child" style="margin-left:0.5rem"><a href="' . $ch->permalink() . '">' . $ch->title() . '</a></li>'.PHP_EOL;
                        
                        $html .= $sp.'                           </ul>'.PHP_EOL.$sp.'        ';                
                    }
                    
                    if($page->isParent())                                        
                      $html .= '</li>'.PHP_EOL;
                    
                    if($c>=$numberOfItems && $numberOfItems != -1) break;
                
                    $c++;
				}
                catch (Exception $e)
                {
					// Continue
				}
                
			}
		}
        
        
        ###
        $html .= $sp.'      </ul>'.PHP_EOL;
        
        if(!$this->getValue('fs_PageMenuNavigationChkRemDefaultsTags')) $html.=$sp.'    </div>'.PHP_EOL;#end content
        
        if(!$this->getValue('fs_PageMenuNavigationChkRemDefaultsTags')) $html.=$sp.'  </div>'.PHP_EOL;#end plugin
        
        $html.=$sp.'</div>'.PHP_EOL; #end block
        
        //remove spaces
        if( $this->getValue('removeSpaces') )  
            $html=$this->RemoveSpaces($html);
        
        return $html;
    }
    
    private function PageMenuStaticPages()
    {   
		global $L, $site, $pages;
        $html='';
        $sp=$this->getValue('space');
        
        #create array
        $ignorePages=explode(',', $this->getValue('fs_PageMenu_StaticRemPages') );        
        for($i=0;$i<count($ignorePages);$i++) #replace values only with numbers
            $ignorePages[$i]=((int) filter_var($ignorePages[$i], FILTER_SANITIZE_NUMBER_INT));
        
        $html.= PHP_EOL.$sp.'<div class="fs-page-menu-static-pages">'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenu_StaticChkRemDefaultsTags')) $html.=$sp.'  <div class="plugin plugin-page-menu-static-pages">'.PHP_EOL;
        
        # show title only if its not empty
        if(!empty($this->getValue('fs_PageMenu_StaticHeaderTitle')))
            $html.=$sp.'   <h2 class="plugin-label">'.$this->getValue('fs_PageMenu_StaticHeaderTitle').'</h2>'.PHP_EOL;
        
        # remove html defaults if checked
        if(!$this->getValue('fs_PageMenu_StaticChkRemDefaultsTags')) $html.=$sp.'    <div class="plugin-content">'.PHP_EOL;
        
        $html .= $sp.'      <ul>'.PHP_EOL;        

		// Show Home page link
		if ($this->getValue('fs_PageMenu_StaticChkAddHomeLink'))
			$html .= $sp.'        <li class="parent"><a href="' . $site->url() . '">' . $L->get('Home page') . '</a></li>'.PHP_EOL;
        ###

		// Show static pages
		$staticPages = buildStaticPages();
        $v=1;
		foreach ($staticPages as $page)
        {
            if($this->getValue('fs_PageMenu_StaticCountLimit')=='0') break;
            
            if( in_array($page->position(), $ignorePages))
            {
                #if you remove parent page doesn't make sense see only child pages (added it too)                
                if($page->hasChildren())
                {
                    $children = $page->children();
                    foreach ($children as $child)
                        $ignorePages[]=$child->position();
                }
                
                continue; #= ignore current execution if it exist and call another
            }   
            
            if ($page->isParent())
            {
                $html .= PHP_EOL.$sp.'        <li class="parent">';            
                $html .= '<a href="' . $page->permalink() . '">' . $page->title() . '</a>';
            }
            
            if ($page->hasChildren() && !$this->getValue('fs_PageMenu_StaticChkChildPages'))
            {   
                $chn = $page->children();
                
                $html .= PHP_EOL.$sp.'                           <ul class="subpage">'.PHP_EOL;
                
                foreach($chn as $ch)
                {
                  $html .= $sp.'                              <li style="margin-left:0.5rem"><a href="' . $ch->permalink() . '">' . $ch->title() . '</a></li>'.PHP_EOL;
                                    
                  $v++;                                    
                  
                  if($v>=$this->getValue('fs_PageMenu_StaticCountLimit') && $this->getValue('fs_PageMenu_StaticCountLimit') != -1) break;                  
                }
                
                $html .= $sp.'                           </ul>'.PHP_EOL.$sp.'        ';                
            }
			
            if ($page->isParent())
                $html .= '</li>'.PHP_EOL;
          
            if($v>=$this->getValue('fs_PageMenu_StaticCountLimit') && $this->getValue('fs_PageMenu_StaticCountLimit') != -1) break;
                      
            $v++;
		}

        ###
        $html .= $sp.'      </ul>'.PHP_EOL;
        
        if(!$this->getValue('fs_PageMenu_StaticChkRemDefaultsTags')) $html.=$sp.'    </div>'.PHP_EOL;#end content
        
        if(!$this->getValue('fs_PageMenu_StaticChkRemDefaultsTags')) $html.=$sp.'  </div>'.PHP_EOL;#end plugin
        
        $html.=$sp.'</div>'.PHP_EOL; #end block
        
        //remove spaces
        if( $this->getValue('removeSpaces') )  
            $html=$this->RemoveSpaces($html);

        return $html;
    }
    
    public function AllSubPlugins($location)
    {
        $subplg='';
        $data=array();
        
        $order=explode(',',$this->getValue('OrderSubPlugins'));
        
        if($this->getValue('fs_PageMenu_LinksEnabled')) 
        {
            if($this->getValue('fs_PageMenuLinksLocationSelected') == $location)
            {  
                $data[]= $this->PageMenuLinks();
            }
        }        
        
        if($this->getValue('fs_PageMenu_NavigationEnabled')) 
        {
            if($this->getValue('fs_PageMenuNavigationLocationSelected') == $location)
            {   
                $data[]= $this->PageMenuNavigation();
            }
        }

        if($this->getValue('fs_PageMenu_StaticEnabled')) 
        {
            if($this->getValue('fs_PageMenu_StaticLocationSelected') == $location)
            {   
                $data[]= $this->PageMenuStaticPages();
            }
        }   

        foreach($order as $x)
            $subplg.=$data[$x];
        
        return $subplg;
    }
    
    public function siteSidebar()
    {   
        return $this->AllSubPlugins(__FUNCTION__ );
    }            
    
    public function pageBegin()
    { 
        return $this->AllSubPlugins(__FUNCTION__ );
    }
	

    public function pageEnd()
    {   
        return $this->AllSubPlugins(__FUNCTION__ );
    }
	    
    public function siteBodyBegin()
    {   
        return $this->AllSubPlugins(__FUNCTION__ );
    }        
	    
    public function siteBodyEnd()
    {   
        return $this->AllSubPlugins(__FUNCTION__ );
    }     
    
	public function install($position=0)
	{
		parent::install($position);		
	}
    
	public function post()
	{   
        if($_POST['fs_PageMenu_LinksMultiple'])
        {
            $valb=$this->CorrectBool($_POST['fs_PageMenu_LinksEnabled']);
            
            $this->db['fs_PageMenu_LinksEnabled'] = $valb;
            
            if($valb)
            {
                $links=$_POST['fs_PageMenu_LinksMultiple'];            
                
                $this->db['fs_PageMenu_LinksMultiple']          = Sanitize::html(json_encode($links));                
                $this->db['fs_PageMenu_LinksHeaderTitle']       = Sanitize::html($_POST['fs_PageMenu_LinksHeaderTitle']);                
                $this->db['fs_PageMenuLinksChkRemDefaultsTags'] = $this->CorrectBool($_POST['fs_PageMenuLinksChkRemDefaultsTags']);
                $this->db['fs_PageMenuLinksLocationSelected']   = Sanitize::html($_POST['fs_PageMenuLinksLocationSelected']);
                
                if($this->getValue('updateDefaultViewJS')) $this->db['ActiveTabDefault']=0;
            }
            
            return $this->save();
        }
        
        if($_POST['OrderSubPlugins'])#SAVE CONFIG
        {
            $this->db['space']=Sanitize::html($_POST['space']);
            $this->db['showPluginLateralEnabled']=$this->CorrectBool($_POST['showPluginLateralEnabled']);
            $this->db['removeSpaces']=$this->CorrectBool($_POST['removeSpaces']);
            $this->db['hideEntryHTMLBlocks']=$this->CorrectBool($_POST['hideEntryHTMLBlocks']);
            $this->db['updateDefaultViewJS']=$this->CorrectBool($_POST['updateDefaultViewJS']);
            
            $this->db['OrderSubPlugins']=Sanitize::html(implode(',',$_POST['OrderSubPlugins']));
            
            return $this->save();
        }
        
        if($_POST['btnSaveNavigation'])
        {   
            $navE=$this->CorrectBool($_POST['fs_PageMenu_NavigationEnabled']);    
            
            $this->db['fs_PageMenu_NavigationEnabled'] = $navE;
           
            if($navE)
            {
                $this->db['fs_PageMenu_NavigationHeaderTitle']      = Sanitize::html($_POST['fs_PageMenu_NavigationHeaderTitle']);
               
                $this->db['fs_PageMenuNavigationChkAddHomeLink']    = $this->CorrectBool($_POST['fs_PageMenuNavigationChkAddHomeLink']);
                
                $this->db['fs_PageMenuNavigationChkRemDefaultsTags']= $this->CorrectBool($_POST['fs_PageMenuNavigationChkRemDefaultsTags']);
                
                $this->db['fs_PageMenuNavigationChkChildPages']     = $this->CorrectBool($_POST['fs_PageMenuNavigationChkChildPages']);
                
                $this->db['fs_PageMenu_NavigationCountLimit']       = (int) Sanitize::html($_POST['fs_PageMenu_NavigationCountLimit']);
               
                $this->db['fs_PageMenuNavigationLocationSelected']  = Sanitize::html($_POST['fs_PageMenuNavigationLocationSelected']);
                
                $this->db['fs_PageMenu_NavigationRemPages']  = Sanitize::html($_POST['fs_PageMenu_NavigationRemPages']);
                
                if($this->getValue('updateDefaultViewJS')) $this->db['ActiveTabDefault']=1;
            }
            
            return $this->save();
        }
        
        if($_POST['btnSaveStatic'])
        {
            $statPg=$this->CorrectBool($_POST['fs_PageMenu_StaticEnabled']);    
            
            $this->db['fs_PageMenu_StaticEnabled'] = $statPg;
            
            if($statPg)
            {
                $this->db['fs_PageMenu_StaticHeaderTitle']      = Sanitize::html($_POST['fs_PageMenu_StaticHeaderTitle']);
                
                $this->db['fs_PageMenu_StaticRemPages']  = Sanitize::html($_POST['fs_PageMenu_StaticRemPages']);
               
                $this->db['fs_PageMenu_StaticLocationSelected']  = Sanitize::html($_POST['fs_PageMenu_StaticLocationSelected']);
               
                $this->db['fs_PageMenu_StaticCountLimit']       = (int) Sanitize::html($_POST['fs_PageMenu_StaticCountLimit']);
               
                $this->db['fs_PageMenu_StaticChkAddHomeLink']    = $this->CorrectBool($_POST['fs_PageMenu_StaticChkAddHomeLink']);
                
                $this->db['fs_PageMenu_StaticChkRemDefaultsTags']    = $this->CorrectBool($_POST['fs_PageMenu_StaticChkRemDefaultsTags']);
                
                $this->db['fs_PageMenu_StaticChkChildPages']    = $this->CorrectBool($_POST['fs_PageMenu_StaticChkChildPages']);
                
                if($this->getValue('updateDefaultViewJS')) $this->db['ActiveTabDefault']=2;
            }
            
            return $this->save();
        }
	}

	# Added useful functions via trait
	use FS_Utils_Page_Menu;
}