<script>
window.addEventListener('load', (event) => 
{ 
   sortable('#fs_PageMenu_LinksMultiple_LIST', 
    {
        forcePlaceholderSize: true,
        placeholderClass: 'placeholderClass',
        hoverClass: 'hoverClass'
    })
    
    sortable('#fs_PageMenu_LinksMultiple_LIST')[0].addEventListener('sortupdate', function(e) 
    {
        LoadLinksEvents()
    });
    
    function LoadLinksEvents()
    {
        let listLI   = document.getElementById('fs_PageMenu_LinksMultiple_LIST').getElementsByTagName('li');
        let linkURL  = document.getElementById('fs_PageMenu_LinksURL');
        let linkText = document.getElementById('fs_PageMenu_LinksTextLink');
        
        for(let i=0;i<=listLI.length-1;i++)
        {
            listLI[i].addEventListener('click',function()
            {
                l=document.getElementById('selectedItem');
                l.value=i;
            });
            
            listLI[i].addEventListener('dblclick',function()
            {
                linkURL.value  = this.getAttribute("data-link");
                linkText.value = this.innerText;
                this.remove();
                
                sortable('#fs_PageMenu_LinksMultiple', 'reload');
                LoadLinksEvents();
            });
        }
    }
    
    LoadLinksEvents();
    
    document.querySelector('#fs_PageMenu_LinksBtnAdd').addEventListener('click',function()
    {
        sortable('#fs_PageMenu_LinksMultiple_LIST', 'reload');
        
        let linkurl=document.getElementById('fs_PageMenu_LinksURL').value;
        let linktext=document.getElementById('fs_PageMenu_LinksTextLink').value;
        
        if(linktext.length<=0) return;
        
        let sel=document.getElementById('fs_PageMenu_LinksMultiple_LIST');
        
        let item = document.createElement("li");        
            item.setAttribute('data-link',linkurl);
            item.appendChild(document.createTextNode(linktext));
        
        hidel=document.getElementById('selectedItem');
        
        if(hidel.value=='last')
            sel.appendChild(item);
        else         
        document.getElementById('fs_PageMenu_LinksMultiple_LIST').insertBefore(item,sel.children[hidel.value]);
        
        //Empty values
        document.getElementById('fs_PageMenu_LinksTextLink').value='';
        document.getElementById('fs_PageMenu_LinksURL').value='';
        hidel.value='last';
        
        sortable('#fs_PageMenu_LinksMultiple_LIST', 'reload');
        LoadLinksEvents()
    });
    
    document.getElementById('fs_PageMenu_LinksBtnRemove').onclick=function()
    {
        sortable('#fs_PageMenu_LinksMultiple_LIST', 'reload');
        
        let sel=document.getElementById('fs_PageMenu_LinksMultiple_LIST');
        let indexSelected=document.getElementById('selectedItem');
        
        if(indexSelected.value!='last' && typeof indexSelected.value !== 'undefined' && typeof sel.children[indexSelected.value] !== 'undefined')
            sel.children[indexSelected.value].remove();
        
        LoadLinksEvents()
        sortable('#fs_PageMenu_LinksMultiple_LIST', 'reload');
    }
    
    
    document.getElementById('btnSaveLinks').onclick=function()
    {        
         var select = document.createElement("select");
             select.name = "fs_PageMenu_LinksMultiple[]";
             select.id = "fs_PageMenu_LinksMultiple";
             select.setAttribute('multiple','multiple');
             
            data = document.getElementById('fs_PageMenu_LinksMultiple_LIST').getElementsByTagName('li');
			
        if(data.length<=0) 
		{
			alert("<?php echo $L->get('fs-page-menu-js-message-no-links-found') ?>");
			
			return false;
		}
		
        for (const val of data)
        {
            var option = document.createElement("option");
            option.value = val.getAttribute('data-link')+"<?php echo pluginFS_PageMenu::SEPARATORFS ?>"+val.innerText;
            option.text = val.innerText;
            select.appendChild(option);
        }
        
        for(let i=0;i<select.options.length;i++)
           select.options[i].selected = true; 
       
        this.form.appendChild(select);
        
        this.form.submit();   
    } 
});
</script>