<?php
trait FS_Utils_Page_Menu
{	
    # UTILS FUNCTIONS	
    
	private function OptionEnableDisable($var,$showstatus=true)
	{
		global $L;
		
		$html= '<div class="plgopt">';
		
		if($showstatus) $html.= '<span>'.$L->get('Plugin Status').'</span>';
		
		$html.= '
				<select name="'.$var.'" class="optionplugin">
					 <option value="true" '.($this->getValue($var)===true?'selected':'').'>'.$L->get('fs-enabled').'</option>
					 <option value="false" '.($this->getValue($var)===false?'selected':'').'>'.$L->get('fs-disabled').'</option>
				</select>';
				
		$html.= '</div>';
		
		return $html;
	}
	
	private function Option($arList, $var)
	{
		global $L;
		
		$html  = '<div class="plgopt">';
		$html .= '<select name="'.$var.'" class="optionplugin">'.PHP_EOL;
		
		foreach($arList as $l)
		{
			$selected='';
			
			if($this->getValue($var)===$l)								
			 $html.= '<option selected value="'.$this->getValue($var).'">'. ucfirst( $L->get($this->getValue($var)) ).'</option>'.PHP_EOL;
		    else
			  $html.= '<option value="'.$l.'">'.ucfirst( $L->get($l) ).'</option>'.PHP_EOL;
		}
		
		$html.='</select>'.PHP_EOL;
		
		$html.= '</div>'.PHP_EOL;
		
		return $html;
	}
    
	private function OptionLocation($var)
	{
		global $L;
		
		$html  = '<div class="plgopt">';
		$html .= '<select name="'.$var.'" class="optionplugin">'.PHP_EOL;
		
		foreach($this->arLocations as $l)
		{
			$selected='';
			
			if($this->getValue($var)===$l)								
			 $html.= '<option selected value="'.$this->getValue($var).'">'.$L->get($this->getValue($var)).'</option>'.PHP_EOL;
		    else
			  $html.= '<option value="'.$l.'">'.$L->get($l).'</option>'.PHP_EOL;
		}
		
		$html.='</select>'.PHP_EOL;
		
		$html.= '</div>'.PHP_EOL;
		
		return $html;
	}    
    
	private function OptionCheckBox($var)
	{
		$ck = ( $this->getValue($var) ? ' checked' : '' );	
		
		return PHP_EOL.
        "<input type=\"hidden\" name=\"$var\" id=\"hidden_$var\" value=\"0\">".PHP_EOL.
		"<input type=\"checkbox\" name=\"$var\" id=\"$var\" value=\"1\"$ck>".PHP_EOL;		
	}

	private function OptionRadio($nameVar,$data,$id)
	{
		$ck = ( ($this->getValue($nameVar)===$data) ? ' checked' : '' );
		
		return "<input type=\"radio\" name=\"$nameVar\" id=\"$nameVar".'_'.$id."\" value=\"$data\"$ck>";
	}
	
	private function InputTxt($var, $value=false, $class=false, $type='text')
	{	
		if($value) $value=" value=\"$value\"";
		
		if($class) $class=" class=\"$class\"";
        
		return "<input type=\"$type\" name=\"$var\" id=\"$var\"$class$value>";		
	}	
	
	private function Textarea($var, $value=false, $class=false)
	{	
		if($class) $class=" class=\"$class\"";
		
		return "<textarea name=\"$var\" id=\"$var\"$class>$value</textarea>";		
	}		
	
	// Returns the first image from the page content
	private function fsGetImage($content)
	{
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/ii', $content, $matches);
		
		if (!empty($matches[1][0]))
			return $matches[1][0];

		return false;
	}
	
	// Return the image with fallback
	private function fsGetImageURL($page, $id)
	{	
		$img='';
		
		if($page)
		{
			$img=$page->coverImage(true);
					
			if(empty($img))
			{				
				$img = $this->fsGetImage($page->content());
			
				if(empty($img))
					$img=$id;
			}			
		}
		else
		{
			$img=$id;
		}
			
		return $img;
	}
	
	// Return the description with fallback
	private	function getDescription($id,$article=false)
	{
		global $site, $page;
		
		if($article) 
		{
			if( Text::isNotEmpty ( $page->description() ) )
				return $page->description();
		}
		
		if( Text::isNotEmpty ( $this->getValue( $id ) ) )
		 return $this->getValue( $id );
		else 
		  return $site->description();			
	}	
	
	private function CheckIfPageExists()
	{
		#copy from Bludits configs
		$decode = urldecode($_SERVER['REQUEST_URI']); 				
		$explode = explode('?', $decode);
		$uril = basename($explode[0]);	
		
		#defined in functions.php on bl-kernel
		if(buildPage($uril))
			return true;
		else 
			return false;
	}	
	
	# https://stackoverflow.com/questions/7838929/keeping-line-breaks-when-using-phps-domdocument-appendchild/7840997#7840997
    private function identContent($content, $tab="\t")
    {
        // add marker linefeeds to aid the pretty-tokeniser (adds a linefeed between all tag-end boundaries)
        $content = preg_replace('/(>)(<)(\/*)/', "$1\n$2$3", $content);

        // now indent the tags
        $token = strtok($content, "\n");
        $result = ''; // holds formatted version as it is built
        $pad = 0; // initial indent
        $matches = array(); // returns from preg_matches()

        // scan each line and adjust indent based on opening/closing tags
        while ($token !== false) 
        {
            $token = trim($token);
            // test for the various tag states

            // 1. open and closing tags on same line - no change
            if (preg_match('/.+<\/\w[^>]*>$/', $token, $matches)) $indent=0;
            // 2. closing tag - outdent now
            elseif (preg_match('/^<\/\w/', $token, $matches))
            {
                $pad--;
                if($indent>0) $indent=0;
            }
            // 3. opening tag - don't pad this one, only subsequent tags (only if it isn't a void tag)
            elseif (preg_match('/^<\w[^>]*[^\/]>.*$/', $token, $matches))
            {
                $voidTag = false;
                foreach ($matches as $m)
                {
                    // Void elements according to http://www.htmlandcsswebdesign.com/articles/voidel.php
                    if (preg_match('/^<(area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)/im', $m))
                    {
                        $voidTag = true;
                        break;
                    }
                }

                if (!$voidTag) $indent=1;
            }
            // 4. no indentation needed
            else $indent = 0;

            // pad the line with the required number of leading spaces
            $line = str_pad($token, strlen($token)+$pad, $tab, STR_PAD_LEFT);
            $result .= $line."\n"; // add to the cumulative result, with linefeed
            $token = strtok("\n"); // get the next token
            $pad += $indent; // update the pad size for subsequent lines    
        }    

        return $result;
    }
    
    private function CorrectBool($v)
    {
       if($v=='false' || $v==false) $v=false; else $v=true; 
       
       return $v;
    }

    private function RemoveSpaces($s)
    {
        $s=trim(preg_replace('/\s+/', ' ', $s));
        $s=str_replace('> <', '><', $s);
       
       return $s;
    }
    
    private function printError($var)
    {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }    
}
?>